import { json } from '@sveltejs/kit';
import { db } from '$lib/server/db.js';

/** @type {import('./$types').RequestHandler} */
export async function GET({ params }) {
  try {
    const id = parseInt(params.id);
    const [payments] = await db.query('SELECT * FROM studentPayments WHERE id = ?', [id]);
    
    if (payments.length === 0) {
      return json({ error: 'Data pembayaran tidak ditemukan' }, { status: 404 });
    }
    
    return json({ success: true, data: payments[0] });
  } catch (error) {
    console.error('Get payment error:', error);
    return json({ error: 'Gagal mengambil data pembayaran' }, { status: 500 });
  }
}

/** @type {import('./$types').RequestHandler} */
export async function PUT({ params, request }) {
  try {
    const id = parseInt(params.id);
    const data = await request.json();
    const { studentId, period, billType, startDate, endDate, status, amount, discount, fine, paidDate } = data;

    if (!studentId || !period || !billType || !startDate) {
      return json({ error: 'ID Siswa, Periode, Jenis Tagihan, dan Tanggal Mulai wajib diisi' }, { status: 400 });
    }

    // Hitung total
    const total = (amount || 0) - (discount || 0) + (fine || 0);

    await db.query(
      `UPDATE studentPayments 
       SET studentId = ?, period = ?, billType = ?, startDate = ?, endDate = ?, 
           status = ?, amount = ?, discount = ?, fine = ?, total = ?, paidDate = ?
       WHERE id = ?`,
      [
        studentId,
        period.trim(),
        billType.trim(),
        startDate,
        endDate || null,
        status || 'BB',
        amount || 0,
        discount || 0,
        fine || 0,
        total,
        paidDate || null,
        id
      ]
    );

    return json({ success: true, message: 'Data pembayaran berhasil diupdate' });
  } catch (error) {
    console.error('Update payment error:', error);
    return json({ error: 'Gagal mengupdate data pembayaran' }, { status: 500 });
  }
}

/** @type {import('./$types').RequestHandler} */
export async function DELETE({ params }) {
  try {
    const id = parseInt(params.id);
    await db.query('DELETE FROM studentPayments WHERE id = ?', [id]);
    return json({ success: true, message: 'Data pembayaran berhasil dihapus' });
  } catch (error) {
    console.error('Delete payment error:', error);
    return json({ error: 'Gagal menghapus data pembayaran' }, { status: 500 });
  }
}
